//
//  MCSyncConfig.h
//  GWSyncServices
//
//  Created by Michael Clark on 13/02/07.
//  Copyright 2007 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCSyncConfig : NSObject {
	
	@private
	NSString*       __configFilePath;
	NSDictionary*   __configDictionary;
	
	NSMutableDictionary*   __applicationEntityNameLookUp; // Used to tell if a given entity should trigger a trickle sync
	NSMutableArray*        __activeSyncServicesEntityNames;
	NSMutableDictionary*   __syncConfigLookUp; // Keyed on Sync Services entity names
	NSMutableDictionary*   __entityGroups;
}

- (id)initWithConfigFilePath: (NSString*)path;

- (BOOL)shouldPostpendDocumentIdentifier;
- (NSString*)clientIdentifier;
- (NSNumber*)clientDescriptionVersion;

- (BOOL)shouldSyncApplicationEntityNamed: (NSString*)anEntityName;
	// Checks to see if the application specific entity name is registered to initiate a trickle sync

- (BOOL)warnOnDeleteForEntityNamed: (NSString*)anEntityName;
	// Checks the config to see if the specified entity is registered to causing object deletion warnings
- (NSString*)localizedDeletionWarningMessageForEntityNamed: (NSString*)anEntityName;
	// Looks up the deletion warning key in the localization strings

- (NSArray*)activeSyncServicesEntitieNames;
	// Returns all the active sync services entities that the application supports

- (NSDictionary*)activeEntityGroupConfigs;
	// Returns all the configs for the active entity groups

- (NSArray*)activeEntityGroupIdentifiers;
	// Returns all the active entity groups identifiers

- (NSDictionary*)entityGroupConfigForIdentifier: (NSString*)identifier;

- (NSString*)syncServicesEntityNameForApplicationEntityName: (NSString*)anEntityName;
	// Returns the sync services entity name that matches the given application entity name - the only application entity names that are guaranteed to return a corresponding sync services entity name are those that return YES for shouldSyncApplicationEntityNamed: - there may be cases where there is not a 1 to 1 mapping between SS and App entities, or there might not even be an App entity behind an SS entity, i.e. the SS entity values are derived somehow

- (NSDictionary*)syncConfigForSyncServicesEntityNamed: (NSString*)anEntityName;
	// Returns the sync configuration information for the given sync services entity name - this config tells the MC sync environment what processor gets used to handle the entity specific logic

- (NSDictionary*)syncConfigForApplicationEntityNamed: (NSString*)anEntityName;
	// Returns the sync configuration information for the given application entity name

- (NSString*)entityGroupIdentifierForApplicationEntityName: (NSString*)anEntityName;
	// Returns the identifier for the entity group that this entity belongs to

- (NSString*)entityGroupIdentifierForSyncServicesEntityNamed: (NSString*)anEntityName;
	// Return the identifier for the entity group that this entity belongs to

@end
